#include "mpi.h"
#include <stdio.h>
#include <stdlib.h>

// oets 
int main(int argc, char *argv[]) {
    int rank, N;
    int value;

    MPI_Init(&argc, &argv);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);
    MPI_Comm_size(MPI_COMM_WORLD, &N);

   
    value = 2 * rank;

    for (int phase = 0; phase < N; phase++) {
        int neighbor = -1;

        if ((phase % 2 == 0 && rank % 2 == 0 && rank < N - 1))       neighbor = rank + 1;
        else if ((phase % 2 == 0 && rank % 2 == 1 && rank > 0))      neighbor = rank - 1;
        else if ((phase % 2 == 1 && rank % 2 == 0 && rank > 0))      neighbor = rank - 1;
        else if ((phase % 2 == 1 && rank % 2 == 1 && rank < N - 1))  neighbor = rank + 1;

        if (neighbor != -1) {
            int neighbor_value;
            MPI_Sendrecv(&value, 1, MPI_INT, neighbor, 0,
                         &neighbor_value, 1, MPI_INT, neighbor, 0,
                         MPI_COMM_WORLD, MPI_STATUS_IGNORE);

            // Update value based on relative rank positions
            if (rank < neighbor) {
                if (value < neighbor_value) value = neighbor_value;
            } else {
                if (value > neighbor_value) value = neighbor_value;
            }
        }
    }

    // Each task prints its final value
    printf("%d - %d\n", rank, value);
    fflush(stdout);

    MPI_Barrier(MPI_COMM_WORLD);


    int *all_values = NULL;
    if (rank == N - 1) {
        all_values = (int *)malloc(N * sizeof(int));
    }

    MPI_Gather(&value, 1, MPI_INT, all_values, 1, MPI_INT, N - 1, MPI_COMM_WORLD);

    if (rank == N - 1) {
        for (int i = 0; i < N; i++) {
            printf("%d ", all_values[i]);
        }
        printf("\n");
        free(all_values);
        fflush(stdout);
    }

    MPI_Finalize();
    return 0;
}


